/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.util.io;

import com.t2pellet.strawgolem.util.io.StringConverter;

class StringConverterImpl
implements StringConverter {
    private static final String INTEGER = "int";
    private static final String BOOLEAN = "boolean";
    private static final String DOUBLE = "double";
    private static final String FLOAT = "float";
    private static final String STRING = "java.lang.String";
    private final String value;

    public StringConverterImpl(String value) {
        this.value = value;
    }

    @Override
    public <T> T convert(Class<T> clazz) {
        return (T)(switch (clazz.getTypeName()) {
            case INTEGER -> Integer.parseInt(this.value);
            case BOOLEAN -> Boolean.parseBoolean(this.value);
            case FLOAT -> Float.valueOf(Float.parseFloat(this.value));
            case DOUBLE -> Double.parseDouble(this.value);
            case STRING -> this.value;
            default -> throw new IllegalArgumentException("Invalid type: " + clazz.getTypeName());
        });
    }
}

